#include "stdafx.h"
#include "common.h"
#include "symbol.h"
#include "error.h"
#include "asmutils.h"


CHashedSymbolTable*		theScriptSymbolTable;	//ukazatel na tabulku symbolu skriptu, ta muze obsahovat jen symboly funkci
/*Nasledujici promenne budeme potrebovat pri automaticke deklaraci promennych. Pokud narazime na LVALUE, ktera neni v symbol
tabulce, znamena to ze takova promenna neni nadeklarovana, takze ji musime vlozit do symbol tabulky. Ale kde promennou
nadeklarovat. No kdyz deklarovana neni, znamena to ze nic nezmenime kdyz vlozime jeji deklaraci primo pred vyraz nebo deklaraci v jejiz
inicializaci se vyskytla. Proto potrebujeme nasledujici promenne
*/
STATEMENT**		ParentStm = NULL;		//ukazatel na rodicovsky prikaz
void*			ParentExpr = NULL;		//ukazatel na rodiscovsky vyraz, pokud ptrType je 0 znamena to ze tento ukazatel 
										//ukazuje na strukturu typu EXPRESSION, pokud je 1, ukazuje na STATEMENT
int				ptrType = 0;			//udava typ ukazatele, zatim jen ukazatel na vyraz (0) nebo na prikaz (1)


//****************************************************************************************************************
//****************************************************************************************************************
//************************************************Trida CHashedSymbolTable****************************************
//****************************************************************************************************************
//****************************************************************************************************************
//Konstruktor
//****************************************************************************************************************
CHashedSymbolTable::CHashedSymbolTable()
{
	m_Table = NULL;
	m_ParentTable = NULL;
	m_TableSize = 0;
}
//****************************************************************************************************************
//Destruktor
//****************************************************************************************************************
CHashedSymbolTable::~CHashedSymbolTable()
{
	if (m_Table)				//smaz tabulku
		delete [] m_Table;
	m_Table = NULL;
	m_TableSize = 0;
	m_ParentTable = NULL;
}
//****************************************************************************************************************
//Inicializace tabulky
//****************************************************************************************************************
HRESULT	CHashedSymbolTable::Init(int size)
{
	m_Table = new SYMBOL*[size];			//vytvor nove pole predstavujici tabulku. Prvky jsou ukazatele na SYMBOL
	if (!m_Table)							//pokud to nepude, zrejme nedostatek pameti
		return E_OUTOFMEMORY;

	m_TableSize = size;							//uloz si velikost tabulky
	memset(m_Table,0,size*sizeof(SYMBOL*));		//vynuluj vsechny polozky
	return S_OK;
}
//****************************************************************************************************************
//fce pro vraceni hashovaciho cisla pro dany retezec
//****************************************************************************************************************
unsigned int CHashedSymbolTable::GetHash(char* str)
{
	unsigned int hash = 0;

	while (*str)
	{
		hash = (hash << 1) + *str;
		str++;
	}

	return hash % m_TableSize;
}
//****************************************************************************************************************
//fce pro vlozeni symbolu do tabulky
//****************************************************************************************************************
SYMBOL* CHashedSymbolTable::Put(char* key,SymbolKind kind)
{
	unsigned int hash = GetHash(key);

	SYMBOL*	pItem = m_Table[hash];		//nejdriv se mrknem jestli uz v tabulce na pozici dane
	if (pItem)							//hashovacim klicem neco neni, proste jestli se nepokousime
		if (*pItem == key)				//zadat 2x uplne stejnou polozku, respektive polozku se stejnym
			return NULL;				//klicem

	pItem = new SYMBOL;					//polozka v tabulce neni, tak ji tam pridej
	pItem->name = key;
	pItem->kind = kind;
    m_Table[hash] = pItem;

	return pItem;
}
//****************************************************************************************************************
//fce pro vlozeni symbolu ktery predstavuje promennou
//****************************************************************************************************************
SYMBOL*	CHashedSymbolTable::PutVariable(char* variable)
{
	return Put(variable,declarationT);
}
//****************************************************************************************************************
//fce pro vlozeni symbolu ktery predstavuje funkci
//****************************************************************************************************************
SYMBOL*	CHashedSymbolTable::PutFunction(char* function)
{
	return Put(function,functionT);
}
//****************************************************************************************************************
//fce pro vraceni symbolu, vlastne zjisti je symbol definovan v dane tabulce nebo rodicovske
//****************************************************************************************************************
SYMBOL*	CHashedSymbolTable::Get(char* key)
{
	int hash = GetHash(key);

	SYMBOL*	pItem = m_Table[hash];

	//pokud je ukazatel platny
	if (pItem)
	{
		//pokud jde o hledanou polozku
		if (*pItem == key)
			return pItem;  //vratime na ni ukazatel
	}
	
	//nejedna se o hledanou polozku nebo vubec neni v tabulce
	if (m_ParentTable)		//tak hledej v rodicovskych tabulkach
		return m_ParentTable->Get(key);
	
	//pokud nenajdes nikde, vrat NULL
	return NULL;
}
//****************************************************************************************************************
//Fce zjisti zda je dany symbol v tabulce definovan
//****************************************************************************************************************
bool	CHashedSymbolTable::Defined(char* key)
{
	int hash = GetHash(key);				//zjisti hash

	SYMBOL*		pItem = m_Table[hash];		//uloz si ukazatel na symbol z poyice dane hashem

	if (pItem)			//pokud ukazatel plati
	{
		if (*pItem == key)	//zjisti zda se polozky rovnaji
			return true;	//pokud ano, vrat true
	}
	return false;			//pokud ne, neni symbol v teto tabulce definovan
}
//****************************************************************************************************************
//Vytvori novou hash tabulku a nastavi ji ukazatel na rodicovskou tabulku na sebe
//****************************************************************************************************************
CHashedSymbolTable* CHashedSymbolTable::Scope()
{
	CHashedSymbolTable* newTable = new CHashedSymbolTable;	//nova tabulka

	if (FAILED(newTable->Init()))	//inicializace nove tabulky
		return NULL;

	newTable->Parent(this);		//nastavni ukazatele
	return newTable;			//vraceni ukazatele
}

//****************************************************************************************************************
//****************************************************************************************************************
//*********************************************Trida CSymbolChecking**********************************************
//****************************************************************************************************************
//****************************************************************************************************************

//****************************************************************************************************************
//Fce pro kontrolu symbolu v celem skriptu
//****************************************************************************************************************
void CSymbolChecking::Process(SCRIPT* theScript)
{
	process1PassSCRIPT(theScript);

	//zkontroluj chyby vznikle po prvni pruchodu, pokud nake byly
	theLog.ErrorCheck();
	process2PassSCRIPT(theScript);
}

//****************************************************************************************************************
//****************************************************************************************************************
//Prvni pruchod
//****************************************************************************************************************
//****************************************************************************************************************


//****************************************************************************************************************
//fce pro prvni pruchod celym skriptem
//****************************************************************************************************************
void CSymbolChecking::process1PassSCRIPT(SCRIPT* theScript)
{
	theScript->symbolTable = new CHashedSymbolTable;		//vytvoreni symbol tabulky pro cely skript, do ni se ukladaji jen jmena funkci
	theScript->symbolTable->Init();							//inicializace tabulky
	theScriptSymbolTable = theScript->symbolTable;

	if (theScript->toplevels != NULL)
		process1PassTOPLEVEL(theScript->toplevels,theScript->symbolTable);
}
//****************************************************************************************************************
//prvni pruchod toplevelem
//****************************************************************************************************************
void CSymbolChecking::process1PassTOPLEVEL(TOPLEVEL*	toplevel, CHashedSymbolTable* symbolTable)
{
	process1PassFUNCTION(toplevel->function, symbolTable);

	if (toplevel->next != NULL)
		process1PassTOPLEVEL(toplevel->next,symbolTable);
}
//****************************************************************************************************************
//prvni pruchod funkci
//****************************************************************************************************************
void CSymbolChecking::process1PassFUNCTION(FUNCTION* function, CHashedSymbolTable* symbolTable)
{
	SYMBOL* symbol;

	/*v symbolTable bude ukazatel na tabulku celeho skriptu (theScript->symbolTable)
	jmena funkci se tedy budou spravne hledat jen v tehle tabulce
	Jako prvni tu mame kontrolu zda je funkce uz definovana, pokud ano, je v tabulce, ze
	pokud ne, tak funkci nadefinujeme jako symbol v tabulce. Do symbol tabulky se jako klic uklada podpis funkce
	coz je slozenina  jmeno_funkce(pocet_parameru_funkce), coz umizni pouzivat pretizene funkce, s rozdilnym
	poctem parametru. Funkce min(2) a min(4) tedy projdou
	*/
	if (symbolTable->Defined(function->signature))
		theLog.ReportError(function->line_number,"Duplicate declaration of function '%s'",function->name);
	else
	{
		//funkce este neni definovana
		symbol = symbolTable->PutFunction(function->signature);		//vlozeni symbolu funkce do tabulky
		symbol->val.functionS = function;							//ulozeni ukazatele na funkci do symbolu, abychom vedeli kde v kodu je funkce
																	//definovana

		if (function->kind == localT)	//dalsi veci maj cenu jen v pripade lokalni funkce
		{
			function->symbolTable = symbolTable->Scope();		//vytvoreni nove tabulky symbolu pro samostatnou funkci
			if (function->declaration)
				process1PassDECLARATION(function->declaration,function->symbolTable);	//kontrola argumentu
			if (function->statements)
			{
				ParentStm = &(function->statements);
				process1PassSTATEMENT(function->statements,function->symbolTable);	//kontrola tela funkce
			}
		}
	}
}

//****************************************************************************************************************
//fce pro kontrolu deklaraci
//****************************************************************************************************************
void CSymbolChecking::process1PassDECLARATION(DECLARATION* declaration, CHashedSymbolTable* symbolTable)
{
	SYMBOL*	symbol;

	switch (declaration->kind)
	{
	case formalT:
		//opet pokud je argument definovan v tabulce, je tady deklarovan podruhe a to je chyba. Pokud ne,
		//ulozime ho do tabulky. Nemuzeme mit v deklaraci funkce dve promenne se stejnym nazvem
		if (symbolTable->Defined(declaration->val.formalD.name))
			theLog.ReportError(declaration->line_number,"Duplicate declaration of formal '%s'",declaration->val.formalD.name);
		else
		{
			//ulozeni symbolu do tabulky
			theLog.TraceF("Declared formal '%s'. Line: %i<br>",declaration->val.formalD.name,declaration->line_number);
			symbol = symbolTable->PutVariable(declaration->val.formalD.name);
			//ulozeni ukazatele na uzel deklarace, tj na misto kde je v programu promenna definovana a ke ktere symbol patri
			symbol->val.declarationS = declaration;
		}
		break;
	case variableT:
		//zjistime jestli je symbol v tabulce
		//symbol = symbolTable->Get(declaration->val.variableD.identifiers->name);

		theLog.TraceF("Declared variable '%s'. Line: %i<br>",declaration->val.variableD.identifiers->name,declaration->line_number);
		symbol = symbolTable->PutVariable(declaration->val.variableD.identifiers->name);

		symbol->val.declarationS = declaration;
		declaration->val.variableD.symbol = symbol;

		if (declaration->val.variableD.initialization)
		{
			ptrType = 1;
			process1PassEXPRESSION(declaration->val.variableD.initialization,symbolTable);
		}

		break;
	case simplevarT:
		//opet pokud je symbol definovan, je promenna definovana podruhe a to nemuzeme pripustit, meli bychom v tom bordel
		//a nemohli bychom se rozmyslet jakou promennou kdo kde pouziva
		symbol = symbolTable->Get(declaration->val.simplevarD.name);
		if (symbol)
			theLog.ReportError(declaration->line_number,"Duplicate declaration of variable %s'",declaration->val.simplevarD.name);
		else
		{
			//ulozeni symbolu do tabulky
			theLog.TraceF("Declared simplevar '%s'. Line: %i<br>",declaration->val.simplevarD.name,declaration->line_number);
			symbol = symbolTable->PutVariable(declaration->val.simplevarD.name);
			//ulozeni ukazatele na uzel deklarace, tj na misto kde je v programu promenna definovana a ke ktere symbol patri
			symbol->val.declarationS = declaration;
		}

		if (declaration->val.simplevarD.initialization != NULL)		//kontrola inicializace
		{
			ptrType = 1;
			process1PassEXPRESSION(declaration->val.simplevarD.initialization, symbolTable);
		}
		break;
	}

	if (declaration->next)
		process1PassDECLARATION(declaration->next, symbolTable);
}
//****************************************************************************************************************
//prvni pruchod incicializaci for
//****************************************************************************************************************
void CSymbolChecking::process1PassFORINIT(FORINIT* forinit, CHashedSymbolTable* symbolTable)
{
	switch (forinit->kind)
	{																					//jednoduche, jen volani dalsich fci
	case declarationforinitT:
		process1PassDECLARATION(forinit->val.declarationF, symbolTable);
		break;
	case expressionforinitT:
		process1PassEXPRESSION(forinit->val.expressionF, symbolTable);
		break;
	}

	if (forinit->next)
		process1PassFORINIT(forinit->next, symbolTable);
}
//****************************************************************************************************************
//prvni kontrola prikazu
//****************************************************************************************************************
void CSymbolChecking::process1PassSTATEMENT(STATEMENT* statement, CHashedSymbolTable* symbolTable)
{
	switch (statement->kind)
	{
	case skipT:
		break;
	case expT:
		ptrType = 0;
		ParentExpr = statement->val.expression;
		process1PassEXPRESSION(statement->val.expression, symbolTable);
		break;
	case declstmT:
		/*protoze jazyk podporuje nezadavani datovych typu, vlastne zadavani datovych typu nepodporuje
		vsechny prirazeni budou ve stromu reprezentovany jako deklarace promenne. Takze co musime udelat.
		Podivame se pokud je symbol definovan a pokud ano, zmenime prikaz deklarace na prirazeni, protoze
		promenna uz byla definovana. V opacnem pripade promennou nadefinujeme a ponechame prirazeni.
		To plati jen v pripade ze promenna je i inicializovana. Pokud neni inicializovana, ale je to treba jen g;
		bereme to jako deklaraci a zavolame process1PassDECLARATION a ta rozhodne jestli jde o duplicitni deklaraci
		*/
		if (/*statement->val.declaration->kind == variableT &&*/ statement->val.declaration->val.variableD.initialization)
		{
			//podivame se jestli je symbol definovan
			SYMBOL* tmpSymbol = symbolTable->Get(statement->val.declaration->val.variableD.identifiers->name);
			//pokud ano
			if (tmpSymbol)
			{
				theLog.TraceF("Variable '%s' is already defined. Converting current declaration to assignment. Line %i<br>",statement->val.declaration->val.variableD.identifiers->name,statement->line_number);
				LVALUE* lvalue = makeLVALUEidentifier(statement->val.declaration->val.variableD.identifiers->name);
				EXPRESSION* expassign = makeEXPRESSIONassignment(lvalue,statement->val.declaration->val.variableD.initialization);
				//expassign->val.assignmentE.left->symbol = tmpSymbol;
				*ParentStm = makeSTATEMENTexpression(expassign);
				(*ParentStm)->line_number = statement->line_number;
				(*ParentStm)->val.expression->val.assignmentE.left->symbol = tmpSymbol;

				process1PassEXPRESSION((*ParentStm)->val.expression->val.assignmentE.right,symbolTable);
			}
			else
			{
				//symbol neni definovan nebo definovan je ale neni inicializovan
				ParentExpr = (void*)statement;
				process1PassDECLARATION(statement->val.declaration,symbolTable);
			}
		}
		else
		{
			//symbol neni definovan nebo definovan je ale neni inicializovan
			ParentExpr = (void*)statement;
			process1PassDECLARATION(statement->val.declaration,symbolTable);
		}
		break;
	case returnT:
        if (statement->val.returnS.expression != NULL)
		{
			ptrType = 1;
			ParentExpr = (void*)statement;
			process1PassEXPRESSION(statement->val.returnS.expression, symbolTable);
		}
		break;
	case ifT:
		ptrType = 1;		//ukazatel bude ukazovat na prikaz
		ParentExpr = (void*)statement;	//nastav ukazatel tak aby ukazoval na tento prikaz
		process1PassEXPRESSION(statement->val.ifS.condition, symbolTable);
		ParentStm = &(statement->val.ifS.body);
		process1PassSTATEMENT(statement->val.ifS.body, symbolTable);
		break;
	case ifelseT:
		ptrType = 1;
		ParentExpr = (void*)statement;
		process1PassEXPRESSION(statement->val.ifelseS.condition, symbolTable);
		ParentStm = &(statement->val.ifelseS.ifbody);
		process1PassSTATEMENT(statement->val.ifelseS.ifbody, symbolTable);
		ParentStm = &(statement->val.ifelseS.elsebody);
		process1PassSTATEMENT(statement->val.ifelseS.elsebody, symbolTable);
		break;
	case whileT:
		ptrType = 1;
		ParentExpr = (void*)statement;
		process1PassEXPRESSION(statement->val.whileS.condition, symbolTable);
		ParentStm = &(statement->val.whileS.body);
		process1PassSTATEMENT(statement->val.whileS.body, symbolTable);
		break;
	case forT:
		ptrType = 1;
		ParentExpr = (void*)statement;
		process1PassFORINIT(statement->val.forS.inits, symbolTable);
		process1PassEXPRESSION(statement->val.forS.condition, symbolTable);
		process1PassEXPRESSION(statement->val.forS.updates, symbolTable);
		ParentStm = &(statement->val.forS.body);
		process1PassSTATEMENT(statement->val.forS.body, symbolTable);
		break;
	case sequenceT:
		ParentStm = &(statement->val.sequenceS.firts);
		process1PassSTATEMENT(statement->val.sequenceS.firts, symbolTable);
		ParentStm = &(statement->val.sequenceS.second);
		process1PassSTATEMENT(statement->val.sequenceS.second, symbolTable);
		break;
	case scopeT:
		//vytvoreni tabulky pro novy blok {}
		statement->val.scopeS.symbolTable = symbolTable->Scope();
		ParentStm = &(statement->val.scopeS.statement);
		process1PassSTATEMENT(statement->val.scopeS.statement, statement->val.scopeS.symbolTable);
		break;
	}
}

//****************************************************************************************************************
//prvni kontrola vyrazu
//****************************************************************************************************************
void CSymbolChecking::process1PassEXPRESSION(EXPRESSION* expression, CHashedSymbolTable* symbolTable)
{
	if (expression == NULL)
		return;

	switch (expression->kind)
	{
	case intconstT:
		break;
	case stringconstT:
		break;
	case doubleconstT:
		break;
	case uminusT:
		process1PassEXPRESSION(expression->val.uminusE, symbolTable);
		break;
	case notT:
		process1PassEXPRESSION(expression->val.notE.expression, symbolTable);
		break;
	case lvalueT:
		process1PassLVALUE(expression->val.lvalue, symbolTable);
		break;
	case assignmentT:
		process1PassLVALUE(expression->val.assignmentE.left, symbolTable);
		process1PassEXPRESSION(expression->val.assignmentE.right, symbolTable);
		break;
	case plusassignT:
		process1PassLVALUE(expression->val.plusassignE.left, symbolTable);
		process1PassEXPRESSION(expression->val.plusassignE.right, symbolTable);
		break;
	case minusassignT:
		process1PassLVALUE(expression->val.minusassignE.left, symbolTable);
		process1PassEXPRESSION(expression->val.minusassignE.right, symbolTable);
		break;
	case mulassignT:
		process1PassLVALUE(expression->val.mulassignE.left, symbolTable);
		process1PassEXPRESSION(expression->val.mulassignE.right, symbolTable);
		break;
	case divassignT:
		process1PassLVALUE(expression->val.divassignE.left, symbolTable);
		process1PassEXPRESSION(expression->val.divassignE.right, symbolTable);
		break;
	case modassignT:
		process1PassLVALUE(expression->val.modassignE.left, symbolTable);
		process1PassEXPRESSION(expression->val.modassignE.right, symbolTable);
		break;
	case andassignT:
		process1PassLVALUE(expression->val.andassignE.left, symbolTable);
		process1PassEXPRESSION(expression->val.andassignE.right, symbolTable);
		break;
	case orassignT:
		process1PassLVALUE(expression->val.orassignE.left, symbolTable);
		process1PassEXPRESSION(expression->val.orassignE.right, symbolTable);
		break;
	case shlassignT:
		process1PassLVALUE(expression->val.shlassignE.left, symbolTable);
		process1PassEXPRESSION(expression->val.shlassignE.right, symbolTable);
		break;
	case shrassignT:
		process1PassLVALUE(expression->val.shrassignE.left, symbolTable);
		process1PassEXPRESSION(expression->val.shrassignE.right, symbolTable);
		break;
	case shlT:
		process1PassEXPRESSION(expression->val.shlE.left, symbolTable);
		process1PassEXPRESSION(expression->val.shlE.right, symbolTable);
		break;
	case shrT:
		process1PassEXPRESSION(expression->val.shrE.left, symbolTable);
		process1PassEXPRESSION(expression->val.shrE.right, symbolTable);
		break;
	case prefincT:
	case postincT:
		process1PassLVALUE(expression->val.incE, symbolTable);
		break;
	case postdecT:
	case prefdecT:
		process1PassLVALUE(expression->val.decE, symbolTable);
		break;
	case bitorT:
		process1PassEXPRESSION(expression->val.bitorE.left, symbolTable);
		process1PassEXPRESSION(expression->val.bitorE.right, symbolTable);
		break;
	case bitandT:
		process1PassEXPRESSION(expression->val.bitandE.left, symbolTable);
		process1PassEXPRESSION(expression->val.bitandE.right, symbolTable);
		break;
	case equalsT:
		process1PassEXPRESSION(expression->val.equalsE.left, symbolTable);
		process1PassEXPRESSION(expression->val.equalsE.right, symbolTable);
		break;
	case nequalsT:
		process1PassEXPRESSION(expression->val.nequalsE.left, symbolTable);
		process1PassEXPRESSION(expression->val.nequalsE.right, symbolTable);
		break;
	case lessT:
		process1PassEXPRESSION(expression->val.lessE.left, symbolTable);
		process1PassEXPRESSION(expression->val.lessE.right, symbolTable);
		break;
	case greaterT:
		process1PassEXPRESSION(expression->val.greaterE.left, symbolTable);
		process1PassEXPRESSION(expression->val.greaterE.right, symbolTable);
		break;
	case lequalsT:
		process1PassEXPRESSION(expression->val.lequalsE.left, symbolTable);
		process1PassEXPRESSION(expression->val.lequalsE.right, symbolTable);
		break;
	case gequalsT:
		process1PassEXPRESSION(expression->val.gequalsE.left, symbolTable);
		process1PassEXPRESSION(expression->val.gequalsE.right, symbolTable);
		break;
	case plusT:
		process1PassEXPRESSION(expression->val.plusE.left, symbolTable);
		process1PassEXPRESSION(expression->val.plusE.right, symbolTable);
		break;
	case minusT:
		process1PassEXPRESSION(expression->val.minusE.left, symbolTable);
		process1PassEXPRESSION(expression->val.minusE.right, symbolTable);
		break;
	case mulT:
		process1PassEXPRESSION(expression->val.mulE.left, symbolTable);
		process1PassEXPRESSION(expression->val.mulE.right, symbolTable);
		break;
	case divT:
		process1PassEXPRESSION(expression->val.divE.left, symbolTable);
		process1PassEXPRESSION(expression->val.divE.right, symbolTable);
		break;
	case modT:
		process1PassEXPRESSION(expression->val.modE.left, symbolTable);
		process1PassEXPRESSION(expression->val.modE.right, symbolTable);
		break;
	case andT:
		process1PassEXPRESSION(expression->val.andE.left, symbolTable);
		process1PassEXPRESSION(expression->val.andE.right, symbolTable);
		break;
	case orT:
		process1PassEXPRESSION(expression->val.orE.left, symbolTable);
		process1PassEXPRESSION(expression->val.orE.right, symbolTable);
		break;
	case callT:
		/*kontrola jmena funkce je az v druhem pruchodu*/
		if (expression->val.callE.arguments)		//takze tady zkontrolujeme jen argumenty
			process1PassEXPRESSION(expression->val.callE.arguments, symbolTable);
		break;
	}

	if (expression->next)
		process1PassEXPRESSION(expression->next, symbolTable);
}
//****************************************************************************************************************
//kontrola lvalue
//****************************************************************************************************************
void CSymbolChecking::process1PassLVALUE(LVALUE* lvalue, CHashedSymbolTable* symbolTable)
{
	SYMBOL* symbol;
	switch (lvalue->kind)
	{
	case identifierT:
		/*protoze jazyk zabezpecuje automatickou deklaraci promennych, promenne ktere nejsou definovane
		nadefinujeme a k zadnemu erroru tak nemuze dojit
		*/
		symbol = symbolTable->Get(lvalue->val.idL);
		if (!symbol)
		{
			theLog.TraceF("Variable '%s' is not declared. Inserting automatic declaration. Line: %i<br>",lvalue->val.idL,lvalue->line_number);

			symbol = symbolTable->PutVariable(lvalue->val.idL);

			//musime pred vyraz kde se promenna vyskytuje vlozit deklaraci promenne
			//vytvor deklaraci
			DECLARATION* varDeclaration = makeDECLARATIONvariable(makeIDENTIFIER(lvalue->val.idL),makeEXPRESSIONintconst(0));
			varDeclaration->val.variableD.symbol = symbol;
			symbol->val.declarationS = varDeclaration;
			//vytvor prikaz deklarace
			STATEMENT*	StmDeclaration = makeSTATEMENTdeclaration(varDeclaration);
			STATEMENT*	StmExpression = NULL;

			if (ptrType == 0)
			{
				//vytvor prikaz vyraz
				//ParentExpr ukayoval na strukturu EXPRESSION, abychom mohli udelat sekvenci prikazu, potrebujeme
				//STATEMENT ukazujici na EXPRESSION
				StmExpression = makeSTATEMENTexpression((EXPRESSION*)ParentExpr);
			}
			else if (ptrType == 1)
			{
				StmExpression = (STATEMENT*)ParentExpr;
			}

			ptrType = 0;
			//vytvor sekvenci prikazu deklarace a puvodniho vyrazu
			STATEMENT*	StmSequence = makeSTATEMENTsequence(StmDeclaration,StmExpression);
			StmSequence->line_number = (*ParentStm)->line_number;

			*(ParentStm) = StmSequence;

			//nastav adresu ParentStm na druhy prikaz, coz je puvodne proverovany prikaz
            ParentStm = &((*ParentStm)->val.sequenceS.second);
		}
		
		lvalue->symbol = symbol;

		break;
	}
}

//****************************************************************************************************************
//****************************************************************************************************************
/*Druhy pruchod stromem*/
//****************************************************************************************************************
//****************************************************************************************************************

//****************************************************************************************************************
//Druhy pruchod skriptem
//****************************************************************************************************************
void CSymbolChecking::process2PassSCRIPT(SCRIPT* theScript)
{
	if (theScript->toplevels)
		process2PassTOPLEVEL(theScript->toplevels, theScript->symbolTable);
}
//****************************************************************************************************************
//Druhy pruchod vetvemi stromu
//****************************************************************************************************************
void CSymbolChecking::process2PassTOPLEVEL(TOPLEVEL* toplevel, CHashedSymbolTable* symbolTable)
{
	process2PassFUNCTION(toplevel->function);

	if (toplevel->next)
		process2PassTOPLEVEL(toplevel->next, symbolTable);
}
//****************************************************************************************************************
//Druhy pruchod funkcemi, listy stromu
//****************************************************************************************************************
void CSymbolChecking::process2PassFUNCTION(FUNCTION* function)
{
	if (function->kind == localT)
		if (function->statements)
			process2PassSTATEMENT(function->statements, function->symbolTable);
}
//****************************************************************************************************************
//Druhy pruchod deklaraci
//****************************************************************************************************************
void CSymbolChecking::process2PassDECLARATION(DECLARATION* declaration, CHashedSymbolTable* symbolTable)
{
	switch (declaration->kind)
	{
	case formalT:
		break;
	case variableT:
		if (declaration->val.variableD.initialization)
			process2PassEXPRESSION(declaration->val.variableD.initialization, symbolTable);
		break;
	case simplevarT:
		if (declaration->val.simplevarD.initialization)
			process2PassEXPRESSION(declaration->val.simplevarD.initialization, symbolTable);
		break;
	}

	if (declaration->next)
		process2PassDECLARATION(declaration->next, symbolTable);
}
//****************************************************************************************************************
//Druhy pruchod inicializaci cyklu for
//****************************************************************************************************************
void CSymbolChecking::process2PassFORINIT(FORINIT* forinit, CHashedSymbolTable* symbolTable)
{
	switch (forinit->kind)
	{
	case declarationforinitT:
		process2PassDECLARATION(forinit->val.declarationF, symbolTable);
		break;
	case expressionforinitT:
		process2PassEXPRESSION(forinit->val.expressionF, symbolTable);
		break;
	}

	if (forinit->next)
		process2PassFORINIT(forinit->next, symbolTable);
}
//****************************************************************************************************************
//Druhy pruchod prikazy
//****************************************************************************************************************
void CSymbolChecking::process2PassSTATEMENT(STATEMENT* statement, CHashedSymbolTable* symbolTable)
{
	switch (statement->kind)
	{
	case skipT:
		break;
	case expT:
		process2PassEXPRESSION(statement->val.expression, symbolTable);
		break;
	case declstmT:
		process2PassDECLARATION(statement->val.declaration, symbolTable);
		break;
	case returnT:
        if (statement->val.returnS.expression != NULL)
			process2PassEXPRESSION(statement->val.returnS.expression, symbolTable);
		break;
	case ifT:
		process2PassEXPRESSION(statement->val.ifS.condition, symbolTable);
		process2PassSTATEMENT(statement->val.ifS.body, symbolTable);
		break;
	case ifelseT:
		process2PassEXPRESSION(statement->val.ifelseS.condition, symbolTable);
		process2PassSTATEMENT(statement->val.ifelseS.ifbody, symbolTable);
		process2PassSTATEMENT(statement->val.ifelseS.elsebody, symbolTable);
		break;
	case whileT:
		process2PassEXPRESSION(statement->val.whileS.condition, symbolTable);
		process2PassSTATEMENT(statement->val.whileS.body, symbolTable);
		break;
	case forT:
		process2PassFORINIT(statement->val.forS.inits, symbolTable);
		process2PassEXPRESSION(statement->val.forS.condition, symbolTable);
		process2PassEXPRESSION(statement->val.forS.updates, symbolTable);
		process2PassSTATEMENT(statement->val.forS.body, symbolTable);
		break;
	case sequenceT:
		process2PassSTATEMENT(statement->val.sequenceS.firts, symbolTable);
		process2PassSTATEMENT(statement->val.sequenceS.second, symbolTable);
		break;
	case scopeT:
		process2PassSTATEMENT(statement->val.scopeS.statement, statement->val.scopeS.symbolTable);
		break;
	}
}
//****************************************************************************************************************
//Druhy pruchod vyrazy
//****************************************************************************************************************
void CSymbolChecking::process2PassEXPRESSION(EXPRESSION* expression, CHashedSymbolTable* symbolTable)
{
	SYMBOL*	symbol;
	if (expression == NULL)
		return;

	switch (expression->kind)
	{
	case intconstT:
		break;
	case stringconstT:
		break;
	case uminusT:
		process2PassEXPRESSION(expression->val.uminusE, symbolTable);
		break;
	case notT:
		process2PassEXPRESSION(expression->val.notE.expression, symbolTable);
		break;
	case lvalueT:
		break;
	case assignmentT:
		process2PassEXPRESSION(expression->val.assignmentE.right, symbolTable);
		break;
	case plusassignT:
		process2PassEXPRESSION(expression->val.plusassignE.right, symbolTable);
		break;
	case minusassignT:
		process2PassEXPRESSION(expression->val.minusassignE.right, symbolTable);
		break;
	case mulassignT:
		process2PassEXPRESSION(expression->val.mulassignE.right, symbolTable);
		break;
	case divassignT:
		process2PassEXPRESSION(expression->val.divassignE.right, symbolTable);
		break;
	case modassignT:
		process2PassEXPRESSION(expression->val.modassignE.right, symbolTable);
		break;
	case andassignT:
		process2PassEXPRESSION(expression->val.andassignE.right, symbolTable);
		break;
	case orassignT:
		process2PassEXPRESSION(expression->val.orassignE.right, symbolTable);
		break;
	case shlassignT:
		process2PassEXPRESSION(expression->val.shlassignE.right, symbolTable);
		break;
	case shrassignT:
		process2PassEXPRESSION(expression->val.shrassignE.right, symbolTable);
		break;
	case shlT:
		process2PassEXPRESSION(expression->val.shlE.left, symbolTable);
		process2PassEXPRESSION(expression->val.shlE.right, symbolTable);
		break;
	case shrT:
		process2PassEXPRESSION(expression->val.shrE.left, symbolTable);
		process2PassEXPRESSION(expression->val.shrE.right, symbolTable);
		break;
	case postincT:
		break;
	case prefincT:
		break;
	case postdecT:
		break;
	case prefdecT:
		break;
	case equalsT:
		process2PassEXPRESSION(expression->val.equalsE.left, symbolTable);
		process2PassEXPRESSION(expression->val.equalsE.right, symbolTable);
		break;
	case nequalsT:
		process2PassEXPRESSION(expression->val.nequalsE.left, symbolTable);
		process2PassEXPRESSION(expression->val.nequalsE.right, symbolTable);
		break;
	case lessT:
		process2PassEXPRESSION(expression->val.lessE.left, symbolTable);
		process2PassEXPRESSION(expression->val.lessE.right, symbolTable);
		break;
	case greaterT:
		process2PassEXPRESSION(expression->val.greaterE.left, symbolTable);
		process2PassEXPRESSION(expression->val.greaterE.right, symbolTable);
		break;
	case lequalsT:
		process2PassEXPRESSION(expression->val.lequalsE.left, symbolTable);
		process2PassEXPRESSION(expression->val.lequalsE.right, symbolTable);
		break;
	case gequalsT:
		process2PassEXPRESSION(expression->val.gequalsE.left, symbolTable);
		process2PassEXPRESSION(expression->val.gequalsE.right, symbolTable);
		break;
	case plusT:
		process2PassEXPRESSION(expression->val.plusE.left, symbolTable);
		process2PassEXPRESSION(expression->val.plusE.right, symbolTable);
		break;
	case minusT:
		process2PassEXPRESSION(expression->val.minusE.left, symbolTable);
		process2PassEXPRESSION(expression->val.minusE.right, symbolTable);
		break;
	case mulT:
		process2PassEXPRESSION(expression->val.mulE.left, symbolTable);
		process2PassEXPRESSION(expression->val.mulE.right, symbolTable);
		break;
	case divT:
		process2PassEXPRESSION(expression->val.divE.left, symbolTable);
		process2PassEXPRESSION(expression->val.divE.right, symbolTable);
		break;
	case modT:
		process2PassEXPRESSION(expression->val.modE.left, symbolTable);
		process2PassEXPRESSION(expression->val.modE.right, symbolTable);
		break;
	case andT:
		process2PassEXPRESSION(expression->val.andE.left, symbolTable);
		process2PassEXPRESSION(expression->val.andE.right, symbolTable);
		break;
	case orT:
		process2PassEXPRESSION(expression->val.orE.left, symbolTable);
		process2PassEXPRESSION(expression->val.orE.right, symbolTable);
		break;
	case bitandT:
		process2PassEXPRESSION(expression->val.bitandE.left, symbolTable);
		process2PassEXPRESSION(expression->val.bitandE.right, symbolTable);
		break;
	case bitorT:
		process2PassEXPRESSION(expression->val.bitorE.left, symbolTable);
		process2PassEXPRESSION(expression->val.bitorE.right, symbolTable);
		break;
	case callT:
		/*Budeme jen zjistovat zda je funkce definovana. Pokud je, musi se nachazet v symbol tabulce celeho skriptu
		pouzivani promenne jako funkce neni vzhledem k automaticke deklaraci promennych mozne. Muzeme mit promennou
		min a funkci min
		*/
		//nejdriv vytvorime docasny podpis
		char* signature = stringConcat(expression->val.callE.name,makeSignature(expression->val.callE.arguments),NULL);
		char* signature2 = NULL;
		//pak zkusime jestli je symbol v tabulce
		symbol = theScriptSymbolTable->Get(signature);
		if (!symbol)
		{
			//pokud tam neni, zkusime jestli nejde o pretizenou fci s neznamym poctem parametru
			signature2 = stringConcat(expression->val.callE.name,"(-1)",NULL);
			symbol = theScriptSymbolTable->Get(signature2);
			if (!symbol)
				//Pokud nejde ani o funkci s neznamym poctem parametru, jde o chybu
				theLog.ReportError(expression->line_number,"Error: Function '%s' is referenced but not defined\n",expression->val.callE.name);
			else
			{
				//funkce je definovana, uloz si ukazatel na symbol a jmeno nastav na podpis
				expression->val.callE.symbol = symbol;
				expression->val.callE.name = signature2;
			}
		}
		else
		{
			//funkce je definovana, uloz si ukazatel na symbol a jmeno nastav na podpis
			expression->val.callE.symbol = symbol;
			expression->val.callE.name = signature;
		}

        if (expression->val.callE.arguments)
			process2PassEXPRESSION(expression->val.callE.arguments, symbolTable);
		break;
	}

	if (expression->next)
		process2PassEXPRESSION(expression->next, symbolTable);
}